#subtitle_autotrans.py
'''
字幕ファイルをGASを利用して自動翻訳
字幕ファイルは.srt形式
通信を使うので５分継続したら１５秒休む

'''

from tkinter import *
from tkinter import filedialog as fdlg
from tkinter import messagebox as mbx
import re,os,sys
import requests
import threading
import pickle
import time

import read_textfile_inc as rti
import translate_inc as tri
import inputentry_inc as inp
import conf_inc as coni
import dirfile_inc as dfi
import twinlistbox as twin

#設定ファイル
inifile = 'subtitle_autotrans.ini'
#version
version = 'v0.7.1'

# 字幕データ構造（元字幕と翻訳後の字幕）
# [
# [ '字幕番号','時間情報',[ライン１,ライン２,..],'(翻訳字幕)'],
# [ '字幕番号','時間情報',[ライン１,ライン２,..],'(翻訳字幕)'],
# ......
# ]
subtitles = []
#subtitles内の位置
NUM = 0
TIME = 1
SRC = 2
TRNS = 3
#現在のブロックに継続しているブロック数。
#直前のブロックで完結していれば０になる。
lastblock = 0
#lastblockが１以上の場合直前ブロックのテキストが入る
lasttext = ''
#GASの翻訳スクリプトへのURL
gas_url = ''
#中断フラグ
cutoff_flg = False
#翻訳処理結果
trans_result = ''
#翻訳言語
srclang = '英語'
tgtlang = '日本語'

#----------------------------------
# subtitleファイル(.srt)をブロック毎のリストにして返す
#----------------------------------
def read_subtitle(file):
  subslist = []
  subwork = []
  subline = []
  try:
    #with open(file,encoding = "utf-8-sig") as fp:
    #  lines = fp.readlines()
    #エンコーディングを調査してから字幕ファイルを開くことにした。
    #utf-8のファイル先頭にあるBOMマーク(\ufeff)がデータとして読み込
    #まれてしまう場合もあるので。
    res = rti.read_textfile(file)
    if res:
      lines = res[1].splitlines()
    else:
      return []

    linetype = 0  #next 0:num_str 1:time_str 2:subtile 3~:subtitle or ''
    for idx,line in enumerate(lines):
      #line = line.strip()
      if linetype == 0: #for num_str
        if line and re.search('^[0-9]+$',line):
          subwork.append(line)
          linetype += 1
        else:
          raise Exception('Not_Subtitle_file: linecnt={}'.format(idx+1))
      elif linetype == 1:  # for time_str
        if re.search('^[0-9][0-9]:[0-9][0-9]:',line):
          subwork.append(line)
          linetype += 1
        else:
          raise Exception('Not_Subtitle_file: linecnt={}'.format(idx+1))
      elif linetype == 2:  # for sub_str
        if not line:
          raise Exception('no_subtile_text: linecnt={}'.format(idx+1))
        else:
          subline.append(line)
          linetype += 1
      elif linetype >= 3:  # for sub_str or ''
        if not line:
          subwork.append(subline)
          subwork.append('')  #翻訳テキストスペース確保
          #ブロックを追加
          subslist.append(subwork)
          #作業用リスト等クリア
          subwork = []
          subline = []
          linetype = 0
        else:
          subline.append(line)
          linetype += 1
    if subline: #最終のブロックが残っていたら
      subwork.append(subline)
      subwork.append('')
      subslist.append(subwork)

    return subslist  

  except Exception as err:
    mbx.showerror('エラー','read_subtitle():'+str(err))
    return []

#-------------------------------------------
#翻訳を中断したデータをpickleに保存する
#次回以降に選択により継続できるようにする。
#-------------------------------------------
def cutoff(idx):
  global subtitles, inifile, srt, cutoff_flg, period

  msg = '翻訳を中断します。次回以降に翻訳を継続できるようにしますか？'
  if mbx.askyesno('翻訳中断',msg):
    #保存するファイル名を選択
    res = coni.read_item(inifile,'dirname')
    dn = res['dirname'].strip() if res else ''
    savefile = fdlg.asksaveasfilename(title='保存先のファイル名を入力',
                                      initialdir=dn)
    if savefile:
      #dirname保存
      coni.update_item(inifile,'dirname',os.path.dirname(savefile))
      #idx:subtitlesの中の翻訳済み最終要素のidx
      #srt:翻訳対象.srtファイル名
      with open(savefile,'wb') as fp:
        pickle.dump([subtitles,idx,srt,period],fp)
  cutoff_flg = False
  
#------------------------------------------
# 翻訳作業を中断するためにcutoff_flgをセットするだけ
#-------------------------------------------
def cutoff_flg_set(ev=None):
  global cutoff_flg, trans_thread

  if 'trans_thread' in globals():
    cutoff_flg = True

#-----------------------------------
# 保存したsubtitlesのデータを読み込んで返す
# [subtitles,idx,srt_name,period]
#----------------------------------
def load_subtitles():
  global inifile
  #dirname取得
  res = coni.read_item(inifile,'dirname')
  dn = res['dirname'].strip() if res else ''
  fname = fdlg.askopenfilename(title='途中保存したファイルを選択',
                               initialdir=dn)
  if fname:
    #dirname保存
    coni.update_item(inifile,'dirname',os.path.dirname(fname))
    try:
      with open(fname,'rb') as fp:
        data = pickle.load(fp)
    except Exception as err:
      mbx.showerror('エラー','load_subtitles():'+str(err))
      return False
    return data  #[subtitles,idx,srt_name,period]

#-------------------------------------
# subtitlesのデータを.srt形式で出力する
# 翻訳元と翻訳先、翻訳先だけの２つのファイルを出力
# careful:
#   True  .srt出力しない場合の確認を行う
#   False 同上の確認しない。
#-------------------------------------
def outtosrt(careful=False):
  global subtitles, inifile
  msg = '２種類の字幕ファイルを出力します。'
  msg += '\n・原文と訳文を併記したファイル(1_)'
  msg += '\n・訳文だけのファイル(2_)'
  mbx.showinfo('説明',msg)
  while True:
    res = coni.read_item(inifile,'dirname')
    dn = res['dirname'].strip() if res else ''
    ftype = [('srt','*.srt'),('all','*.*')]
    fname = fdlg.asksaveasfilename(title='出力ファイル名を指定(.srt)',
                                   defaultextension='.srt',
                                   filetypes=ftype,initialdir=dn)
    if fname:
      coni.update_item(inifile,'dirname',os.path.dirname(fname))
      bothf = dfi.joinpath(os.path.dirname(fname),'1_'+os.path.basename(fname))
      onlyf = dfi.joinpath(os.path.dirname(fname),'2_'+os.path.basename(fname))
      bfp = open(bothf,'w')
      ofp = open(onlyf,'w')
      for i in subtitles:
        bfp.write(i[NUM]+'\n'+i[TIME]+'\n')
        ofp.write(i[NUM]+'\n'+i[TIME]+'\n')
        for j in i[SRC]:
          bfp.write(j+'\n')
        bfp.write(i[TRNS]+'\n\n')
        ofp.write(i[TRNS]+'\n\n')
      bfp.close()
      ofp.close()
      msg = '{}と{}に出力しました'.format(bothf,onlyf)
      mbx.showinfo('.srt出力',msg)
      break
    else:
      if careful:
        msg = 'このまま終了すると翻訳データが'+\
              'すべて破棄されます。よろしいですか。'
        if mbx.askyesno('注意',msg):
          break
      else:
        break

#---------------------------------------------
# 中断ファイルから直接.srt出力を行う
#---------------------------------------------
def srtfromsave():
  global subtitles
  data = load_subtitles()  #[subtitles,idx,srt_name]
  if data:
    subtitles = data[0]
  else:
    return
  outtosrt()
  subtitles = []  #クリア
  
#------------------------------------------
# subtitlesのデータをインデックスの番号から順次翻訳する
# start:翻訳を開始する位置(デフォルト０)
def subtitle_translate(start=0):
  global subtitles, lastblock, lasttext, cutoff_flg, trans_result
  global period # period:True 文末検知をする :False 文末検知しない（ブロック単位）

  #処理時間計測
  start_time = time.time()
  for idx,blk in enumerate(subtitles[start:],start): #start:idxの開始番号
    #blk[SRC]:元字幕のリスト

    #とりあえずリスト内の字幕はスペースでつなぐ
    if len(blk[SRC])>1:
      sub = ' '.join(blk[SRC])
    else:
      sub = blk[SRC][0]
    #<i>,</i>などのタグを取り除く
    sub = re.sub('<.+?>','',sub)
    #lastblockの有無だけで直前ブロックを判断する
    if lastblock:
      sub = '{} {}'.format(lasttext,sub)
    #最後が.(ピリオド),?,!で終わっていなければ、次ブロックに継続
    #２バイト文字の場合も一応考慮
    #if re.search(r'[^\.\?\!。？！]$',sub):
    if (period and re.search(r'[^\.\?\!。？！]$',sub)) or \
       (lastblock and re.search(r'[^\.\?\!。？！]$',sub)):
      lastblock += 1
      lasttext = sub
    else:
      #翻訳実施
      trns_res = translate(sub)
      #翻訳エラーフラグをiniファイルに書き込んで終了し次回起動時に
      #gas_urlの再入力を求める
      if not trns_res:
        translate_error()
        trans_result = -1
        return
        #root.destroy()
        #sys.exit()  #すでに翻訳されたデータをどうするか？
        
      #翻訳結果をsubtitlesに格納
      update_subtitles(idx,trns_res)

      #継続情報クリア
      lastblock = 0
      lasttext = ''

      #print([idx,sub,trns_res])
      printprogress([idx,sub,trns_res])

      #中断フラグ参照
      if cutoff_flg:
        #idxを渡す
        trans_result = idx
        return
      #連続5分翻訳したら10秒休み
      now = time.time()
      if int(now - start_time) > 60 * 5:
        #print('waiting..10sec..')
        printprogress('waiting..10sec..','str')
        time.sleep(10)
        start_time = time.time()
      
  trans_result = 0
  return

#--------------------------------------
#端末に出力せずTextウィジェットに出力する
#msg:出力するデータ
#msgtype：'list'-->リストデータ|’str’-->文字列
# listデータ:[idx, sub, trns_res]
def printprogress(msg,msgtype='list'):
  global dispwin
  if msgtype == 'list':
    dispwin.insert('{}, [{}], [{}]'.format(*msg))
  else:
    dispwin.insert(msg)

#表示用Windowを開く
def opentextwin():
  global root,dispwin
  dispwin = textwin(root,title='進捗表示')

#表示用windowを閉じる
def closetextwin():
  global dispwin
  if 'dispwin' in globals():
    dispwin.destroy()

#進捗を表示するウィンドウクラス
#Textwin class
class textwin():
  def __init__(self,parent,title=None):
    self.root = Toplevel(parent)
    if title:
      self.root.title(title)
    self.body()
    
  def body(self):
    fr = Frame(self.root)
    fr.pack(expand=1,fill=BOTH)
    self.outtw = Text(fr)
    self.outtw.pack(expand=1,fill=BOTH)
    #ｘコントロール制御
    self.root.protocol("WM_DELETE_WINDOW", self.notclose)

  def insert(self,text):
    self.normal()
    self.outtw.insert(END,text+'\n')
    self.outtw.see(END)
    self.disabled()
    
  def normal(self):
    self.outtw['state'] = NORMAL

  def disabled(self):
    self.outtw['state'] = DISABLED
    
  def notclose(self):
    pass

  def destroy(self):
    self.root.destroy()

#----------------------------------------
# 翻訳エラーが発生した場合の処理
def translate_error():
  #翻訳エラーフラグをinifileに
  coni.update_item(inifile,'translate_error','ERROR')
  msg = '翻訳に失敗しました。作業を終了します。'
  msg += '\n次回起動時に翻訳urlの再入力が必要です。'
  mbx.showerror('通信エラー',msg)
  
#----------------------------------
# gasを使って翻訳する
#----------------------------------
def translate(text):
  global gas_url, srclang, tgtlang
  
  src = tri.langdic[srclang]
  tgt = tri.langdic[tgtlang]
  return tri.get_translated_text(url=gas_url,srctext=text,srclang=src,
                                 tgtlang=tgt,replcr=False)

#----------------------------
#翻訳されたテキストをsubtitlesに格納する
#lastblockを元に継続するブロックに同じ翻訳を挿入する		
#  lastblockが０なら継続ブロックなし。
#  １なら１つ前のブロックから継続している。
#idx:subtitlesの現在のインデックス
#text:翻訳されたテキスト
#-----------------------------
def update_subtitles(idx,text):
  global subtitles, lastblock
  #テキストを格納するブロックのインデックスの範囲で
  for i in range(idx-lastblock,idx+1):
    subtitles[i][TRNS] = text

#----------------------------------------
# 翻訳用gas_urlの確認
# retype_url=True inifileにurlが存在しても入力を求める
#--------------------------------------------
def gas_url_check(retype_url=False):
  global inifile, gas_url, root

##  #設定ファイルパス生成
##  inifile = dfi.joinpath(dfi.getscriptdir(),inifile)
  #設定ファイルからGAS_url情報を取得
  res = coni.read_item(inifile,'gas_url')
  #翻訳エラーフラグ確認
  err = coni.read_item(inifile,'translate_error')
  type_url_flg = False
  if err and err['translate_error']=='ERROR':
    type_url_flg = True
  if not res or not res['gas_url']:
    type_url_flg = True
  if retype_url:
    type_url_flg = True
  if type_url_flg:
    if res:
      inistr = res['gas_url']
    else:
      inistr = ''
    #urlの入力を求める
    gas_url = inp.main(title='Google Apps Script',
                       msg='翻訳用GAS_scriptのURLを入力してください',
                       inistr=inistr,leng=50)
    if gas_url:
      if check_trans_url(gas_url):
        #設定ファイルに登録
        coni.update_item(inifile,'gas_url',gas_url)
        if err:
          #翻訳エラーフラグをクリア
          coni.update_item(inifile,'translate_error','')
        mbx.showinfo('お知らせ','翻訳URLが登録されました')
        return True
      else:
        #正常なURLではない
        msg = '{} は正常な翻訳URLではありません'.format(gas_url)
        mbx.showerror('エラー',msg)
        return False
    else:
      #既存のurlもない場合
      #既存のurl情報を削除する
      if not inistr:
        mbx.showinfo('お知らせ','翻訳用のGAS_urlは必須です。')
        return False
      else:
        gas_url = inistr
        return True
  else:
    gas_url = res['gas_url']
    return True

#翻訳GAS_Script URLのチェック
def check_trans_url(url):
  res = tri.get_translated_text(
    url,
    srctext='Test',
    srclang=tri.langdic['英語'],
    tgtlang=tri.langdic['日本語'],
    replcr=False)
  if res:
    if res.strip() == 'テスト':
      return True
    else:
      return False
  else:
    return False

#----------------------------------------
# 翻訳終了時の処理
#----------------------------------------
def end_jobs():
  global cutoff_flg, trans_result, root, subtitles

  #表示用Windowを閉じる
  closetextwin()
  #中断で終わった場合 cutoff_flg=True & trans_result >= 0
  if cutoff_flg and trans_result:
    cutoff(trans_result)
  #正常終了 cutoff_flg==False & trans_result==0
  elif not cutoff_flg and not trans_result:
    outtosrt(careful=True)
#    for idx,blk in enumerate(subtitles):
#      print(idx,blk)
  #翻訳エラー cutoff_flg==False & trans_result==-1
  
#-------------------------------------
# subtitle_translate()スレッドの終了をチェックする
#-------------------------------------
def waiting_thread():
  global trans_thread, cutoff_flg, trans_result, root

  if not trans_thread.is_alive():
    trans_thread.join()
    #終了時の処理
    end_jobs()
  else:
    threadid = root.after(200,waiting_thread)

#------------------------------------------
#rootウィンドウを閉じる
#------------------------------------------
def root_close():
  global root,trans_thread
  
  #threadingが稼働中であればcut_off処理をしてから終了に
  if 'trans_thread' in globals() and trans_thread.is_alive():
    cutoff_flg_set()
  else:  
    root.destroy()
  
#---------------------------------------
# 処理メイン
#-----------------------------------------
def main():
  global root, subtitles, inifile, srt
  global trans_thread

  if not gas_url_check():
    return
  #inifileからディレクトリ情報取得
  res = coni.read_item(inifile,'dirname')
  dn = res['dirname'].strip() if res else ''
  srt = fdlg.askopenfilename(title='.srt形式の字幕ファイルを選択',
                             initialdir=dn)
  if srt:
    #inifileにディレクトリ記録
    coni.update_item(inifile,'dirname',os.path.dirname(srt))
    #.srtから読込み
    subtitles = read_subtitle(srt)
    #.srt_file read error
    if not subtitles:
      return
    #表示用window
    opentextwin()
    #翻訳作業は別スレッドで
    trans_thread = threading.Thread(target=subtitle_translate)
    trans_thread.start()

    #threadが終わるのを待つ
    waiting_thread()

#-------------------------------------------
# 翻訳作業を再開
#-------------------------------------------
def restart():
  global root, subtitles, inifile, srt
  global trans_thread, period

  if not gas_url_check():
    return
  data = load_subtitles()
  if not data:
    return
  else:
    #表示用window
    opentextwin()
    
    subtitles, idx, srt, period = data

    if not period:
      mbx.showinfo('お知らせ','文末を意識しないモードです')
    #ボタン表示更新
    showperiodmode()

    #翻訳作業は別スレッドで
    #idxまでは翻訳できているのでidx+1から
    trans_thread = threading.Thread(target=subtitle_translate,args=(idx+1,))
    trans_thread.start()

    #threadが終わるのを待つ
    waiting_thread()

#---------------------------------------------
#翻訳言語の選択
#---------------------------------------------
def selectlang():
  global srclang, tgtlang, root, btnvar
  langlist = list(tri.langdic.keys())
  twlbox = twin.twinlistbox(root,title='翻訳言語の選択',llist=langlist,
                            rlist=langlist,llbl='原文言語',rlbl='翻訳言語')
  if twlbox.result:
    src = twlbox.result[0][1]
    tgt = twlbox.result[1][1]
    if src == tgt:
      mbx.showerror('あれっ？','翻訳元と翻訳先が同じ言語になってます。')
      return
    else:
      srclang = src
      tgtlang = tgt
      btnvar.set('言語の選択（現在:{}から{}）'.format(srclang,tgtlang))
      
#---------------------------------------------
#GAS翻訳URLの編集
#現在のURLを初期値に与える
#---------------------------------------------
def editgasurl():
  gas_url_check(retype_url=True)

#-----------------------------------------------
def showperiodmode():
  global peripd,peridovar
  if period:
    txt = '(現在：文末を意識して翻訳する)'
  else:
    txt = '(現在：文末を--意識せずに--翻訳する)'
  periodvar.set(txt)
  
#--------------------------------------------
#現在の文末モードを反転させる
def changeperiodmode():
  global period
  period = False if period else True
  showperiodmode()

#-------------------------------------------
if __name__=='__main__':
  global root, btnvar, period, periodvar

  root = Tk()
  root.title('字幕翻訳ヘルパー({})'.format(version))

  #設定ファイルパス生成
  inifile = dfi.joinpath(dfi.getscriptdir(),inifile)

  Button(root,text='.srtファイルを指定して通常スタート',
         command=main).pack(padx=20,pady=5,fill=BOTH)
  period = True
  periodvar = StringVar()
  periodvar.set('(現在：文末を意識して翻訳する)')
  Button(root,textvariable=periodvar,
         command=changeperiodmode).pack(padx=20,pady=5,fill=BOTH)
  Button(root,text='翻訳作業を中断する',
         command=cutoff_flg_set).pack(fill=BOTH,padx=20,pady=5)
  Button(root,text='中断ファイルを読み込んで翻訳を再開する',
         command=restart).pack(fill=BOTH,padx=20,pady=5)
  Button(root,text='中断ファイルから.srtを出力する',
         command=srtfromsave).pack(fill=BOTH,padx=20,pady=5)
  btnvar = StringVar()
  btnvar.set('言語の選択（現在: {}から{}）'.format(srclang,tgtlang))
  Button(root,textvariable=btnvar,command=selectlang).pack(fill=BOTH,
                                                   padx=20,pady=5)
  Button(root,text='GAS翻訳URLを編集する',
         command=editgasurl).pack(fill=BOTH,padx=20,pady=5)  
  Button(root,text='終了',command=root_close).pack(padx=20,pady=5,fill=BOTH)
  #rootサイズ固定
  root.resizable(False,False)
  #すべてはメインループがなければ始まらん
  root.mainloop()
